/*************************************************/
/* Examples Program For "ET-dsPIC33WEB-V1" Board */
/* Hardware    : ET-dsPIC33WEB-V1.0              */
/* Target MCU  : dsPIC33FJ128GP708               */
/*       	   : X-TAL : 8.00 MHz                */
/* Config Fosc : XTAL = 8MHz (XT+PLL)            */
/*             : PLLPRE[4..0] = 00000 (N1=2)     */
/*             : VCO Input = 8MHz / 2 = 4MHz     */
/*             : PLLDIV[8..0] = 0x26(M=40)       */
/*             : VCO Output = 4 x 40MHz = 160MHz */
/*             : PLLPOST[1:0] = 0:0 (N2=2)       */
/*             : Fosc = 160MHz / 2 = 80MHz       */
/*             : Fcy = Fosc/2 = 80MHz /2 = 40MHz */
/* Compiler    : MPLAB + C30 V3.01  		     */
/* Write By    : Eakachai Makarn(ETT CO.,LTD.)   */
/* Last Update : 16/August/2007                  */
/* Function    : Example Use INT3(RA2) Interrupt */
/*             : LED Toggle ON/OFF on RA3        */	
/*************************************************/
/* INT3(RA2) Toggle RA3(ON/OFF LED) on Interrupt */
/* Connect RA2 to SW1 & Connect RA3 to LED1      */
/*  -> Press SW1 Toggle LED1                     */
/*************************************************/

#include "p33FJ128GP708.h"                             				// dsPIC33FJ128GP708 MPU Register

/* Setup Configuration For ET-dsPIC33WEB-V1 */
_FOSCSEL(FNOSC_PRIPLL & 											// Select Primary OSC = XT + PLL
         IESO_OFF )													// Startup With User Select OSC
_FOSC(FCKSM_CSDCMD &        										// Clock Switch Disabled	
      OSCIOFNC_OFF &												// OSC2 Pin = Clock O/P
      POSCMD_XT)													// Primary OSC = XT 
_FWDT(FWDTEN_OFF &           										// Disable Watchdog Timer 
      WINDIS_OFF &          										// Disabled Windowed WDT
      WDTPRE_PR128 &        										// Watchdog prescaler=1:128
      WDTPOST_PS32768)     											// Watchdog postscaler=1:32,768
_FPOR(FPWRT_PWR128)       											// Power-on Reset Value = 128ms
_CONFIG3(JTAGEN_OFF);												// Disable JTAG Interface
/* End of Configuration For ET-dsPIC33WEB-V1 */

/* Prototype Function */
void delay(unsigned long int);										// Delay Time Function

/**************************/
/* INT3 Interrupt Service */
/* Active by Port Pin RA2 */
/**************************/
void _ISR _INT3Interrupt(void)
{  
  LATAbits.LATA3 = !LATAbits.LATA3; 								// Toggle Output RA3 (0 = ON LED, 1 = OFF LED)
  while(PORTAbits.RA2 |= 1);										// Wait INT3(RA2) Signal Release
  delay(1000000);													// Debounce
  IFS3bits.INT3IF = 0;												// Reset INT3 Interrupt Flag
}

int main(void)
{  
  /* Start of PLL Config Fcy = 40MIPS */
  CLKDIV &= 0xFFE0;													// PLLPRE[4..0] = 00000 (N1=2)
  CLKDIV &= 0xFF3F;													// PLLPOST[1:0] = 00 (N2=2)
  PLLFBD  = 0x26;													// PLLDIV[8..0] = 000100110(M=40)
  while(!OSCCONbits.LOCK);											// Wait PLL to Lock
  OSCCONbits.CLKLOCK = 1;											// Disable PLL Modify
  /* End of PLL Config Fly = 40MIPS */
  
  /* Start of Config INT3 */
  INTCON2bits.INT3EP = 1;											// Falling Edge Trigger Interrupt
  
  // INT3 Interrupt Control 
  IEC3bits.INT3IE     = 1;											// Enable INT3 Interrupt
  IPC13bits.INT3IP = 7;												// INT3 Interrupt Priority = 7
  /* End of Config INT3 */

  /* Config RA3 to Drive LED */
  TRISAbits.TRISA3 = 0;												// Config RA3 = Output
  LATAbits.LATA3 = 0; 												// Output RA3 = "0" (ON LED)
 
  // Loop Continue
  while(1);
}	  
  
/***********************/
/* Delay Time Function */
/*    1-4294967296     */
/***********************/
void delay(unsigned long int count1)
{
  while(count1 > 0) {count1--;}										// Loop Decrease Counter	
}
